package poly.op;

import poly.*;

/**
 * @author DXN, SW
 */
public class Mul implements IPolyOp {
  
  private IPolyFact _fact;
  private IPolyOp _multMono;
  private IPolyOp _multConst;
  private IPolyOp _addOp;
  private IPoly _zero;
  
  public Mul(IPolyFact f) {
    _fact = f;
    _multMono = new MultMono(f);
    _multConst = new MulConst(f);
    _addOp = new AddOp(f);
    _zero = _fact.makeConstPoly(0.0);
  }
  
  public Object constCase(final IConstPoly pol, Object... q) {
    if(pol.getLeadCoef() == 0.0) {
      // pol = 0, doesn't matter what q is.
      return _zero;
    }
    else {
      // pol != 0
      return ((IPoly)q[0]).execute(_multConst, pol.getLeadCoef());
    }
  }
  
  public Object nonConstCase(INCPoly pol, Object... q) {
    // pol = non-Const & != 0,  q could be = 0
    // Multiply q by the leading monomial of pol:
    IPoly p = (IPoly)((IPoly)q[0]).execute(_multMono, pol);
    return p.execute(_addOp, pol.getLowerPoly().execute(this, q));
  }
}



